import mongoose from "mongoose";
import dotenv from "dotenv";

dotenv.config();

// Vehicle Schema
const vehicleSchema = new mongoose.Schema({
  registeration_number: { type: String, required: true, unique: true },
  car_title: { type: String },
  car_description: { type: String },
  created_at: { type: String },
  updated_at: { type: String },
  remark: { type: String },
  company: { type: String },
  name: { type: String },
  model: { type: String },
  year_made: { type: Number },
  fuel_type: { type: String, enum: ["petrol", "diesel", "electirc", "hybrid"] },
  rented_by: { type: String },
  rating: { type: String },
  seats: { type: Number },
  transmition: { type: String, enum: ["manual", "automatic"] },
  image: { type: Array },
  description: { type: String },
  title: { type: String },
  price: { type: Number },
  base_package: { type: String },
  with_or_without_fuel: { type: Boolean },
  insurance_end: { type: Date },
  registeration_end: { type: Date },
  pollution_end: { type: Date },
  certificates: {
    fitness: { type: String },
    registration: { type: String },
    rc: { type: String },
    pollution: { type: String },
  },
  car_type: { type: String },
  isDeleted: { type: String, default: false },
  location: { type: String, required: true },
  district: { type: String, required: true },
  isBooked: { type: Boolean, default: false },
  isAdminAdded: { type: Boolean, default: true },
  addedBy: { type: String, default: 'admin' },
  isAdminApproved: { type: Boolean, default: true },
  isRejected: { type: Boolean, default: false }
});

const Vehicle = mongoose.model("Vehicle", vehicleSchema);

const sampleVehicles = [
  // Kochi Vehicles
  {
    registeration_number: "KL-07-AB-1234",
    car_title: "Maruti Swift - Comfortable Hatchback",
    car_description: "Well maintained Maruti Swift, perfect for city drives",
    company: "Maruti",
    name: "Swift",
    model: "MARUTI SWIFT Petrol AT",
    year_made: 2022,
    fuel_type: "petrol",
    seats: 5,
    transmition: "automatic",
    image: ["https://imgd.aeplcdn.com/664x374/n/cw/ec/54399/swift-exterior-right-front-three-quarter-63.jpeg"],
    price: 1500,
    car_type: "Hatchback",
    location: "kalamassery : skoda service",
    district: "Kochi",
    isBooked: false,
    isAdminApproved: true
  },
  {
    registeration_number: "KL-07-CD-5678",
    car_title: "Hyundai Alcazar - Premium SUV",
    car_description: "Spacious 7-seater SUV with premium features",
    company: "Hyundai",
    name: "Alcazar",
    model: "HYUNDAI ALCAZAR Diesel AT",
    year_made: 2023,
    fuel_type: "diesel",
    seats: 7,
    transmition: "automatic",
    image: ["https://imgd.aeplcdn.com/664x374/n/cw/ec/141115/alcazar-exterior-right-front-three-quarter-3.jpeg"],
    price: 3500,
    car_type: "Suv",
    location: "kalamassery : volkswagen",
    district: "Kochi",
    isBooked: false,
    isAdminApproved: true
  },
  {
    registeration_number: "KL-07-EF-9012",
    car_title: "VW Polo - Sporty Hatchback",
    car_description: "German engineering at its best",
    company: "Volkswagen",
    name: "Polo",
    model: "VW POLO Petrol MT",
    year_made: 2021,
    fuel_type: "petrol",
    seats: 5,
    transmition: "manual",
    image: ["https://imgd.aeplcdn.com/664x374/n/cw/ec/34046/polo-exterior-right-front-three-quarter-2.jpeg"],
    price: 1800,
    car_type: "Hatchback",
    location: "cheranallur : volkswagen",
    district: "Kochi",
    isBooked: false,
    isAdminApproved: true
  },

  // Kottayam Vehicles
  {
    registeration_number: "KL-05-GH-3456",
    car_title: "Skoda Kushaq - Stylish SUV",
    car_description: "Perfect blend of style and performance",
    company: "Skoda",
    name: "Kushaq",
    model: "SKODA KUSHAQ Petrol AT",
    year_made: 2023,
    fuel_type: "petrol",
    seats: 5,
    transmition: "automatic",
    image: ["https://imgd.aeplcdn.com/664x374/n/cw/ec/44148/kushaq-exterior-right-front-three-quarter-65.jpeg"],
    price: 2800,
    car_type: "Suv",
    location: "ettumanoor : skoda service",
    district: "Kottayam",
    isBooked: false,
    isAdminApproved: true
  },
  {
    registeration_number: "KL-05-IJ-7890",
    car_title: "Maruti Dzire - Elegant Sedan",
    car_description: "Comfortable sedan for long drives",
    company: "Maruti",
    name: "Dzire",
    model: "MARUTI DZIRE Petrol MT",
    year_made: 2022,
    fuel_type: "petrol",
    seats: 5,
    transmition: "manual",
    image: ["https://imgd.aeplcdn.com/664x374/n/cw/ec/45691/dzire-exterior-right-front-three-quarter-4.jpeg"],
    price: 1600,
    car_type: "Sedan",
    location: "kottayam : railway station",
    district: "Kottayam",
    isBooked: false,
    isAdminApproved: true
  },

  // Trivandrum Vehicles
  {
    registeration_number: "KL-01-KL-1111",
    car_title: "MG Hector - Feature Rich SUV",
    car_description: "Internet inside SUV with panoramic sunroof",
    company: "MG",
    name: "Hector",
    model: "MG HECTOR Petrol AT",
    year_made: 2023,
    fuel_type: "petrol",
    seats: 5,
    transmition: "automatic",
    image: ["https://imgd.aeplcdn.com/664x374/n/cw/ec/130583/hector-exterior-right-front-three-quarter-73.jpeg"],
    price: 3200,
    car_type: "Suv",
    location: "tampanur : central railway station",
    district: "Trivandrum",
    isBooked: false,
    isAdminApproved: true
  },
  {
    registeration_number: "KL-01-MN-2222",
    car_title: "Nissan Magnite - Compact SUV",
    car_description: "Feature loaded compact SUV",
    company: "Nissan",
    name: "Magnite",
    model: "NISSAN MAGNITE PETROL MT",
    year_made: 2022,
    fuel_type: "petrol",
    seats: 5,
    transmition: "manual",
    image: ["https://imgd.aeplcdn.com/664x374/n/cw/ec/44709/magnite-exterior-right-front-three-quarter-18.jpeg"],
    price: 2000,
    car_type: "Suv",
    location: "kazhakootam : railway station",
    district: "Trivandrum",
    isBooked: false,
    isAdminApproved: true
  },

  // Thrissur Vehicles
  {
    registeration_number: "KL-08-OP-3333",
    car_title: "VW Vento - Premium Sedan",
    car_description: "German sedan with powerful engine",
    company: "Volkswagen",
    name: "Vento",
    model: "VW VENTO Petrol AT",
    year_made: 2021,
    fuel_type: "petrol",
    seats: 5,
    transmition: "automatic",
    image: ["https://imgd.aeplcdn.com/664x374/n/cw/ec/34008/vento-exterior-right-front-three-quarter.jpeg"],
    price: 2200,
    car_type: "Sedan",
    location: "thrissur : railway station",
    district: "Thrissur",
    isBooked: false,
    isAdminApproved: true
  },
  {
    registeration_number: "KL-08-QR-4444",
    car_title: "Skoda Slavia - Sporty Sedan",
    car_description: "Sporty sedan with TSI engine",
    company: "Skoda",
    name: "Slavia",
    model: "SKODA SLAVIA PETROL AT",
    year_made: 2023,
    fuel_type: "petrol",
    seats: 5,
    transmition: "automatic",
    image: ["https://imgd.aeplcdn.com/664x374/n/cw/ec/44148/slavia-exterior-right-front-three-quarter-60.jpeg"],
    price: 2500,
    car_type: "Sedan",
    location: "paliyekara : evm mg",
    district: "Thrissur",
    isBooked: false,
    isAdminApproved: true
  },

  // Calicut Vehicles
  {
    registeration_number: "KL-11-ST-5555",
    car_title: "VW Taigun - Compact SUV",
    car_description: "German SUV with turbo engine",
    company: "Volkswagen",
    name: "Taigun",
    model: "VW TAIGUN Petrol MT",
    year_made: 2022,
    fuel_type: "petrol",
    seats: 5,
    transmition: "manual",
    image: ["https://imgd.aeplcdn.com/664x374/n/cw/ec/44148/taigun-exterior-right-front-three-quarter-72.jpeg"],
    price: 2600,
    car_type: "Suv",
    location: "calicut : railway",
    district: "Calicut",
    isBooked: false,
    isAdminApproved: true
  },
  {
    registeration_number: "KL-11-UV-6666",
    car_title: "MG Hector Plus - 7 Seater SUV",
    car_description: "Premium 7 seater SUV for family",
    company: "MG",
    name: "Hector Plus",
    model: "MG HECTOR PLUS Petrol AT",
    year_made: 2023,
    fuel_type: "petrol",
    seats: 7,
    transmition: "automatic",
    image: ["https://imgd.aeplcdn.com/664x374/n/cw/ec/48042/hector-plus-exterior-right-front-three-quarter-3.jpeg"],
    price: 3800,
    car_type: "Suv",
    location: "calicut : airport",
    district: "Calicut",
    isBooked: false,
    isAdminApproved: true
  },
  {
    registeration_number: "KL-11-WX-7777",
    car_title: "Nissan Kicks - Stylish Crossover",
    car_description: "Stylish crossover SUV",
    company: "Nissan",
    name: "Kicks",
    model: "NISSAN KICKS Petrol MT",
    year_made: 2021,
    fuel_type: "petrol",
    seats: 5,
    transmition: "manual",
    image: ["https://imgd.aeplcdn.com/664x374/n/cw/ec/46444/kicks-exterior-right-front-three-quarter.jpeg"],
    price: 2100,
    car_type: "Suv",
    location: "pavangad : evm nissan",
    district: "Calicut",
    isBooked: false,
    isAdminApproved: true
  }
];

async function seedVehicles() {
  try {
    await mongoose.connect(process.env.mongo_uri);
    console.log('Connected to MongoDB');

    // Clear existing vehicles
    await Vehicle.deleteMany({});
    console.log('Cleared existing vehicles');

    // Insert sample vehicles
    await Vehicle.insertMany(sampleVehicles);
    console.log('✅ Vehicles seeded successfully!');
    console.log(`   - ${sampleVehicles.length} vehicles added`);
    console.log('');
    console.log('Vehicles by district:');
    console.log('   - Kochi: 3 vehicles');
    console.log('   - Kottayam: 2 vehicles');
    console.log('   - Trivandrum: 2 vehicles');
    console.log('   - Thrissur: 2 vehicles');
    console.log('   - Calicut: 3 vehicles');

  } catch (error) {
    console.error('Error seeding vehicles:', error);
  } finally {
    await mongoose.disconnect();
    console.log('\nDisconnected from MongoDB');
  }
}

seedVehicles();
